<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>


<!-- ====================================== -->
<!-- This is the main template. For the sake of our simplistic WYSIWIG
editor, we put any complex xsl into templates and just call them from
here -->
<xsl:template match="/">

  <xsl:call-template name="customGreetings"/>

</xsl:template>
<!-- End Main Template -->
<!-- ====================================== -->


<!-- ====================================== -->
<!-- This template does the work of generating the output.-->
<xsl:template name="customGreetings">


  <!-- The 'choose' statement is a conditional similar to a 'switch'
statement or a big 'if-then-else' in Javascript. The html between the
<xsl:when> and </xsl:when> is the output. -->
  <xsl:choose>

    <!-- If there are more than 2 recipients, just use 'Hi all'. This
matches the default greeting behavior. -->
    <xsl:when test="number(doc/composition/to/personCount) &gt; 2 ">
      Hi all, <BR/>
    </xsl:when>


    <!-- If there are exactly 2 recipients, name each recipient by
their first name. This might generate something like, 'Hi Rich &
Joe'. This also matches the default greeting behavior.-->
    <xsl:when test="number(doc/composition/to/personCount) &gt; 1 ">
      Hi <xsl:value-of select="doc/composition/to/person[1]/firstName"/> &amp; <xsl:value-of select="doc/composition/to/person[2]/firstName"/>, <BR/>
    </xsl:when>


    <!-- The next three cases are examples of a custom greeting based on recipient information. For each person for whom you would like a custom greeting, add a condition similar to one of these. The 1st example checks the name, while the 2nd checks the email address. You would usually only pick one of these conditions per recipient.  -->


    <!-- This matches a portion of the recipient's full name. You
would replace 'Rich Waters' with the name meaningful to you, and the
'Yo Richie-boy' with the greeting you would like to use for that
person.  -->
    <xsl:when test="(contains( doc/composition/to/person/displayName, 'Rich Waters'))">
      Yo Richie-boy! <BR/>
    </xsl:when>

    
    <!-- This tests a specific email address. You would replace the
'info@preside.io' with an email address meaningful to you, and you
would replace the 'Hey awesome app makers,' with your own custom
greeting -->
    <xsl:when test="doc/composition/to/person/emailAddress = 'info@preside.io'">
      Hey awesome app makers,<BR/>
    </xsl:when>


    <!-- This matches is a  portion of the recipient's email address. You would replace 'preside.io' with the a domain meaningful to you.  -->
    <xsl:when test="(contains( doc/composition/to/person/emailAddress, 'preside.io'))">
        Dear <xsl:value-of select="doc/composition/to/person/displayName"/>:
       <BR/>
    </xsl:when>



    <!-- If none of the other conditions are met, then use the standard greeting -->
    <xsl:otherwise>
      Hi <xsl:value-of select="doc/composition/to/person/firstName"/>, <BR/>
    </xsl:otherwise>


  </xsl:choose>

</xsl:template>
<!-- ====================================== -->


</xsl:stylesheet>
